dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 305, 250, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 235, 400, "assets/images/table/redtable", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 200;


-- Group 1
guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);

-- Group 2

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 6, 20000);

-- Group 3

guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 7, 44000);

-- Group 4

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 8, 72000);


-- Group 5

guest = LManager.GenGuest(male04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(9, 11, 100000);




LManager:AdjustGuestTolerance(150);

-- Custom event!


LManager:SetLevelSetting ("bridesmaidsDelay", 50000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);


-- Set up the Level Settings
LManager:SetLevelNumber(1,4);
LManager:SetLevelScores(3200, 5000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_2.ogg","assets/audio/music/Dance Dance 1.ogg");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );